function [fig] = fi(image,varargin)

if(isempty(varargin))
    fig=figure('units','normalized','outerposition',[0 0 1 1]);
else
    fig=figure('units','normalized','outerposition',[0 0 1 1],'Name',varargin{1});
end
if(isa(image,'gpuArray'))
    tmp=squeeze(gather(image));
    if size(tmp,3)>3
        tmp=tmp(:,:,1:3);
    end
    imagesc(tmp)
elseif(isa(image,'vectorValuedFunction2D'))
    imagesc(image.getData())
else
    tmp=squeeze(image);
    if size(tmp,3)>3
        tmp=tmp(:,:,1:3);
    end
    imagesc(tmp)
end
if size(squeeze(image),3) == 1
    colorbar
end
axis image