function [ image ] = refocusEpi( epi,focus,aperture)
%REFOCUSEPI computes a focus with an artificial aperture focused to offset
%focus
%   Detailed explanation goes here

if ndims(epi)==4 %linear lightfield
    episize=size(epi);

    offset=ceil(focus);



    image=zeros(episize(1:end-1)-[0,offset*episize(end),0]);
    [Xoref, Yoref] = meshgrid(1:size(epi,2),1:size(epi,1));
    [Xref, Yref] = meshgrid(1:size(image,2),1:size(image,1));

    center=(episize(end)-1)/2;

    images2use=max(1,floor(center-aperture)):min(ceil(center+aperture),episize(end));

    for c=1:size(image,3)

        % epi_offset=zeros(size(stack,2)-offset*n+1,size(stack,3),n);
        for i=images2use
            tmp= interp2( Xoref,Yoref,squeeze(epi(:,:,c,i)),Xref+focus*(episize(end)-i),...
                                                            Yref,'linear');

        %     epi_offset(:,:,i)=squeeze(stack(line,((n-i)*offset+1):(end-i*offset+1),:,i));
        %squeeze(epi(:,((episize(end)-i)*offset+1):(end-i*offset),:,i))
            image(:,:,c)=image(:,:,c)+tmp;

        end
    end
    image=image/length(images2use);
elseif ndims(epi)==5 %lytro LF
    episize=[size(epi,3) size(epi,4)];
    
    if size(aperture)==[size(epi,1),size(epi,2)]
        bokeh=single(aperture)./sum(aperture(:));
    else
        bokeh = fspecial('gaussian',[size(epi,1),size(epi,2)],aperture(1));
    end
        
    [Xref, Yref] = meshgrid(1:size(epi,4),1:size(epi,3));
    center=([size(epi,1),size(epi,2)]+1)/2;
    
    mask=zeros([episize 3],'single');
    image=zeros([episize 3],'single');
    
    for iX=1:size(epi,1)
        for iY=1:size(epi,2)
            e=[iX;iY]-center';
            for c=1:size(image,3)
                currentEPI=squeeze(epi(iX,iY,:,:,c));
                if sum(currentEPI(:))~=0 && bokeh(iX,iY)~=0
                    tmp= bokeh(iX,iY)*interp2(Xref,Yref,squeeze(epi(iX,iY,:,:,c)),Xref+focus*e(2),...
                                                                                  Yref+focus*e(1),'linear');
                    mask(:,:,c)=mask(:,:,c)+bokeh(iX,iY)*~isnan(tmp);

                    tmp(isnan(tmp))=0;

                    image(:,:,c)=image(:,:,c)+tmp;
                end
            end
        end
    end
    image=image./mask;
end
end

